﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0076_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

Try {
    $DevToolsGenAiSettings = Get-ItemPropertyValue 'HKLM:\Software\Policies\Google\Chrome' -Name DevToolsGenAiSettings
    if($DevToolsGenAiSettings -eq 2){
        Log-Message -message "DevToolsGenAiSettings configured value: $DevToolsGenAiSettings"
        Exit 0
    } else {
        Log-Message -message "DevToolsGenAiSettings configured incorrect value: $DevToolsGenAiSettings"
        Exit 1
    }
} Catch {
    Log-Message -message "The property does not exist or an error occurred: $_"
    Exit 1
}